% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableTrend.R
\name{tableTrend}
\alias{tableTrend}
\title{Create a visual table from a summariseTrend() result}
\usage{
tableTrend(result, type = NULL, style = NULL)
}
\arguments{
\item{result}{A summarised_result object (output of \code{summariseTrend()}).}

\item{type}{Type of formatting output table between \code{gt}, \code{datatable} and
\code{reactable}. Default is \code{"gt"}.}

\item{style}{Defines the visual formatting of the table. This argument can be
provided in one of the following ways:
\enumerate{
\item \strong{Pre-defined style}: Use the name of a built-in style (e.g., "darwin").
See \code{visOmopResults::tableStyle()} for available options.
\item \strong{YAML file path}: Provide the path to an existing .yml file defining
a new style.
\item \strong{List of custome R code}: Supply a block of custom R code or a named
list describing styles for each table section. This code must be specific to
the selected table type.
}

If \code{style = NULL}, the function will use global options
(see\code{visOmopResults::setGlobalTableOptions()}) or a _brand.yml file
(if found); otherwise, the default style is applied.}
}
\value{
A formatted table visualisation.
}
\description{
Create a visual table from a summariseTrend() result
}
\examples{
\donttest{
library(OmopSketch)
library(dplyr, warn.conflicts = FALSE)
library(omock)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

result <- summariseTrend(
  cdm = cdm,
  episode = "observation_period",
  event = c("drug_exposure", "condition_occurrence"),
  interval = "years",
  ageGroup = list("<=20" = c(0, 20), ">20" = c(21, Inf)),
  sex = TRUE
)

tableTrend(result = result)

cdmDisconnect(cdm = cdm)
}

}
