% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_output_functions.R
\name{f_plot_spline_surv_extrap}
\alias{f_plot_spline_surv_extrap}
\title{Plot Extrapolated Spline Survival Models per Group}
\usage{
f_plot_spline_surv_extrap(PERSUADE)
}
\arguments{
\item{PERSUADE}{A PERSUADE object returned by \code{\link[=f_PERSUADE]{f_PERSUADE()}}.}
}
\value{
Invisibly returns \code{NULL}. The function draws one or more base R plots as side effects.
}
\description{
Plot Kaplan-Meier curves per group with shaded confidence bands and overlay
fitted spline survival models (hazard, odds, normal scales) extrapolated to
the analysis time horizon. Runs only when \code{PERSUADE$input$spline_mod} is \code{TRUE}.
}
\examples{
\donttest{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
PERSUADE <- f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = TRUE,
  cure_mod = FALSE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
f_plot_spline_surv_extrap(PERSUADE)
}

}
\seealso{
\code{\link[=f_PERSUADE]{f_PERSUADE()}}
}
