% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PVBcorrect_functions.R
\name{acc_sipw}
\alias{acc_sipw}
\title{PVB correction by scaled inverse probability weighted resampling (SIPW)}
\usage{
acc_sipw(
  data,
  test,
  disease,
  covariate = NULL,
  saturated_model = FALSE,
  option = 2,
  ci = FALSE,
  ci_level = 0.95,
  ci_type = "basic",
  b = 1000,
  R = 999,
  seednum = NULL,
  return_data = FALSE,
  return_detail = FALSE,
  show_boot = FALSE,
  r_print_freq = 100,
  description = TRUE
)
}
\arguments{
\item{data}{A data frame, with at least "Test" and "Disease" variables.}

\item{test}{The "Test" variable name, i.e. the test result. The variable must be in binary; positive = 1, negative = 0 format.}

\item{disease}{The "Disease" variable name, i.e. the true disease status. The variable must be in binary; positive = 1, negative = 0 format.}

\item{covariate}{The name(s) of covariate(s), i.e. other variables associated with either test or disease status.
Specify as name vector, e.g. c("X1", "X2") for two or more variables. The variables must be in formats acceptable to GLM.}

\item{saturated_model}{Set as \code{TRUE} to obtain the original Begg and Greenes' (1983) when all possible interactions are included.}

\item{option}{1 = IPW weight, 2 = W_h weight, described in Arifin (2023), modified weight of Krautenbacher (2017).
The default is \code{option = 2}, which is more stable for small weights (Arifin, 2023).}

\item{ci}{View confidence interval (CI). The default is \code{FALSE}.}

\item{ci_level}{Set the CI width. The default is 0.95 i.e. 95\% CI.}

\item{ci_type}{Set confidence interval (CI) type. Acceptable types are "norm", "basic", "perc", and "bca",
for bootstrapped CI. See \code{\link[boot]{boot.ci}} for details.}

\item{b}{The number of repeated samples, b.}

\item{R}{The number of bootstrap samples. Default \code{R = 999}.}

\item{seednum}{Set the seed number for the bootstrapped CI. The default is not set, so it depends on the user
to set it outside or inside the function.}

\item{return_data}{Return data for the bootstrapped samples.}

\item{return_detail}{Return accuracy measures for each of the bootstrapped samples.}

\item{show_boot}{Set to \code{TRUE} to show bootstrap iterations.}

\item{r_print_freq}{Print the current bootstrap sample number at each specified interval.
Default \code{r_print_freq = 100}.}

\item{description}{Print the name of this analysis. The default is \code{TRUE}. This can be turned off for repeated analysis, for example in bootstrapped results.}
}
\value{
A list object containing:
\describe{
  \item{boot_data}{An object of class "boot" from \code{\link[boot]{boot}}.
  Contains Sensitivity, Specificity, PPV, and NPV}
  \item{boot_ci_data}{A list of objects of type "bootci" from \code{\link[boot]{boot.ci}}.
  Contains Sensitivity, Specificity, PPV, NPV.}
  \item{acc_results}{The accuracy results.}
}
}
\description{
Perform PVB correction by scaled inverse probability weighted resampling.
}
\examples{
# point estimates
acc_sipw(data = cad_pvb, test = "T", disease = "D", b = 100, seednum = 12345)
acc_sipw(data = cad_pvb, test = "T", disease = "D", covariate = "X3",
         b = 100, seednum = 12345)

# with bootstrapped confidence interval
acc_sipw(data = cad_pvb, test = "T", disease = "D", ci = TRUE,
         b = 100, R = 9, seednum = 12345)  # use small b, R for testing
}
\references{
\enumerate{
  \item{Arifin, W. N., & Yusof, U. K. (2025). Partial verification bias correction using scaled inverse probability resampling for binary diagnostic tests. PloS One, 20(9), e0321440.}
  \item{Arifin, W. N., & Yusof, U. K. (2022). Partial Verification Bias Correction Using Inverse Probability Bootstrap Sampling for Binary Diagnostic Tests. Diagnostics, 12(11), 2839.}
  \item{Arifin, W. N. (2023). Partial verification bias correction in diagnostic accuracy studies using propensity score-based methods (PhD thesis, Universiti Sains Malaysia). https://erepo.usm.my/handle/123456789/19184}
  \item{Krautenbacher, N., Theis, F. J., & Fuchs, C. (2017). Correcting Classifiers for Sample Selection Bias in Two-Phase Case-Control Studies. Computational and Mathematical Methods in Medicine, 2017, 1–18.}
  \item{Nahorniak, M., Larsen, D. P., Volk, C., & Jordan, C. E. (2015). Using inverse probability bootstrap sampling to eliminate sample induced bias in model based analysis of unequal probability samples. PLoS One, 10(6), e0131765.}
}
}
