% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceDecay.R
\name{polarDecay}
\alias{polarDecay}
\title{Polar transformation functions}
\usage{
polarDecay(
  method = c("power", "gaussian", "logistic"),
  s = 0.5,
  k = 10,
  m = 0.5
)
}
\arguments{
\item{method}{String indicating the transformation to apply.
Must be one of: "power", "gaussian", or "logistic".}

\item{s}{Single numeric value in \code{[0, 1]}. Controls the spread around
the \code{x} mean of the Gaussian function.}

\item{k}{Single numeric value \code{>=1}. Controls the steepness of
the logistic function.}

\item{m}{Single numeric value in \code{[0, 1]}. Specifies the midpoint of
the logistic function.}
}
\value{
Returns a function of the form: \code{function(x, beta) { ... }},
that applies the specified shape-based transformation.
}
\description{
Creates polar transformation functions for
\code{\link{polarProjection}} internal calls. These functions are used to
adjusts signal decay according to point-to-edge angular distances,
with options to attenuate angular shapes.
}
\details{
The polar transformation controls how much the projected signal decays as
a function of the angular distance between a point in pathway space and
a reference edge axis. The function returned by \code{polarDecay()} expects
two arguments, with the following signature:
\code{function(x, beta) { ... }}.

\strong{Power:}
\deqn{x^{\beta}}
where \eqn{x} is a vector of normalized angular distances (in \code{[0, 1]})
and \eqn{beta} is a non-negative exponent that controls the rate of signal
decay. Increasing \eqn{beta} results in a steeper decay rate, modulating
the angular span of the projection.

\strong{Gaussian:}
\deqn{\exp\left(-\frac{(1-x)^2}{2\sigma^2}\right)^{\beta}}
where \eqn{sigma} controls the spread around the mean, creating
fuzzier effect on projections.

\strong{Logistic:}
\deqn{(1 / (1 + \exp(k (x - m))))^{\beta}}
where \eqn{k} is the steepness and \eqn{m} is the function's midpoint,
making more gradual transitions.

These transformations are intended to be plugged into the higher-level
\code{\link{polarProjection}} function, allowing user control over the
polar projection profiles.
}
\examples{
polar.fun <- polarDecay("power")

}
\seealso{
\code{\link{polarProjection}}
}
\author{
Sysbiolab Team
}
