# PeruAPIs - Access Peruvian Data via Public APIs and Curated Datasets
# Version 0.1.0
# Copyright (c) 2025 Renzo Caceres Rossi
# Licensed under the MIT License.
# See the LICENSE file in the root directory for full license text.

# peru_coastline_df

library(testthat)

# Test 1: Confirm the object is a data.frame (not a tibble)
test_that("peru_coastline_df is a data.frame", {
  expect_s3_class(peru_coastline_df, "data.frame")
  expect_false("tbl_df" %in% class(peru_coastline_df))  # Ensure it's not a tibble
})

# Test 2: Confirm it has exactly 2 columns
test_that("peru_coastline_df has 2 columns", {
  expect_equal(length(peru_coastline_df), 2)
})

# Test 3: Confirm it has exactly 23,481 rows
test_that("peru_coastline_df has 23481 rows", {
  expect_equal(nrow(peru_coastline_df), 23481)
})

# Test 4: Confirm column names are correct and in order
test_that("peru_coastline_df has correct column names", {
  expect_named(peru_coastline_df, c("Long", "Lat"))
})

# Test 5: Confirm column types are correct
test_that("peru_coastline_df columns have correct types", {
  expect_type(peru_coastline_df$Long, "double")
  expect_type(peru_coastline_df$Lat, "double")
})
