% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.R
\name{tune_ml_backtest}
\alias{tune_ml_backtest}
\title{Quick grid tuning for tabular pipeline}
\usage{
tune_ml_backtest(
  features_list,
  labels,
  prices,
  fit_fn,
  predict_fn,
  schedule = list(is = 104L, oos = 4L, step = 4L),
  grid = list(top_k = c(10L, 15L), temperature = c(8, 12), method = c("softmax", "rank"),
    transform = c("zscore")),
  group = "pooled",
  selection_defaults = list(top_k = 15L, max_per_group = NULL),
  weighting_defaults = list(method = "softmax", temperature = 12, floor = 0),
  caps = list(max_per_symbol = 0.08),
  group_map = NULL,
  cost_bps = 0,
  freq = 52
)
}
\arguments{
\item{features_list}{List of feature panels.}

\item{labels}{Label panel.}

\item{prices}{Price panel used for backtests (Date + symbols).}

\item{fit_fn, predict_fn}{Model fit and predict functions.}

\item{schedule}{List with elements is, oos, step.}

\item{grid}{list of vectors: \code{top_k}, \code{temperature}, \code{method}, \code{transform}.}

\item{group}{Grouping mode for roll_fit_predict ('pooled'/'per_symbol'/'per_group').}

\item{selection_defaults}{Default selection settings (e.g., top_k).}

\item{weighting_defaults}{Default weighting settings (e.g., method, temperature).}

\item{caps}{Exposure caps (e.g., max_per_symbol/max_per_group).}

\item{group_map}{Optional Symbol->Group mapping.}

\item{cost_bps}{optional one-way cost in basis points for net performance.}

\item{freq}{re-annualization frequency (e.g., 52).}
}
\value{
data.table with metrics per grid row.
}
\description{
Quick grid tuning for tabular pipeline
}
