% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3Update.R
\name{update}
\alias{update}
\alias{update.CDM}
\alias{update.validation}
\alias{update.sim.data}
\alias{update.fit}
\alias{update.is.Qident}
\alias{update.att.hierarchy}
\title{Update Method for Various Objects}
\usage{
update(x, ...)

\method{update}{CDM}(x, ...)

\method{update}{validation}(x, ...)

\method{update}{sim.data}(x, ...)

\method{update}{fit}(x, ...)

\method{update}{is.Qident}(x, ...)

\method{update}{att.hierarchy}(x, ...)
}
\arguments{
\item{x}{An object of class \code{\link[Qval]{CDM}}, \code{\link[Qval]{validation}}, 
\code{\link[Qval]{sim.data}}, \code{\link[Qval]{fit}}, \code{\link[Qval]{is.Qident}}, 
\code{\link[Qval]{att.hierarchy}}.}

\item{...}{Additional arguments specific to the method being updated:
\itemize{
  \item For \code{CDM}: \code{Y}, \code{Q}, \code{model}, \code{method},
    \code{mono.constraint}, \code{maxitr}, \code{verbose}.
  \item For \code{validation}: \code{Y}, \code{Q}, \code{CDM.obj}, \code{par.method},
    \code{mono.constraint}, \code{model}, \code{method}, \code{search.method},
    \code{iter.level}, \code{maxitr}, \code{eps}, \code{alpha.level}, \code{criter},
    \code{verbose}.
  \item For \code{sim.data}: \code{Q}, \code{N}, \code{IQ}, \code{model},
    \code{distribute}, \code{control}, \code{verbose}.
  \item For \code{fit}: \code{Y}, \code{Q}, \code{model}.
  ...
}}
}
\value{
An updated object of the same class as \code{x}, reflecting any changes
  in the supplied parameters.
}
\description{
The \code{update} function provides a unified interface for refreshing or modifying
existing analysis objects produced by the Qval package, including \code{\link[Qval]{CDM}},
\code{\link[Qval]{validation}}, \code{\link[Qval]{sim.data}}, \code{\link[Qval]{fit}}, 
\code{\link[Qval]{is.Qident}}, \code{\link[Qval]{att.hierarchy}} classes. By passing additional arguments,
users can rerun fitting or simulation routines without reconstructing the entire object
from scratch.
}
\details{
The \code{update} methods internally extract the original call arguments
from the input object, combine them with any new parameters provided in
\code{...}, and re-invoke the corresponding constructor (\code{\link[Qval]{CDM}}, 
\code{\link[Qval]{validation}}, \code{\link[Qval]{sim.data}}, \code{\link[Qval]{fit}}, 
\code{\link[Qval]{is.Qident}}), \code{\link[Qval]{att.hierarchy}}. 
This approach ensures consistency and preserves all untouched settings from the original object.
}
\section{Methods (by class)}{
\itemize{
\item \code{update(CDM)}: Update method for \code{CDM} objects

\item \code{update(validation)}: Update method for \code{validation} objects

\item \code{update(sim.data)}: Update method for \code{sim.data} objects

\item \code{update(fit)}: Update method for \code{fit} objects

\item \code{update(is.Qident)}: Update method for \code{is.Qident} objects

\item \code{update(att.hierarchy)}: Update method for \code{att.hierarchy} objects

}}
\examples{
set.seed(123)
library(Qval)

\donttest{
################################################################
# Example 1: summary a CDM object                              #
################################################################
Q <- sim.Q(3, 20)
IQ <- list(P0 = runif(20, 0, 0.2), P1 = runif(20, 0.8, 1))
data.obj <- sim.data(Q, N = 500, IQ = IQ, 
                     model = "GDINA", distribute = "horder")
CDM.obj <- CDM(data.obj$dat, Q, model = "GDINA", method = "BM")
summary(CDM.obj)

CDM.updated <- update(CDM.obj, method = "EM", maxitr = 1000)
summary(CDM.updated)


################################################################
# Example 2: summary a validation object                       #
################################################################
MQ <- sim.MQ(Q, 0.1)
CDM.obj2 <- CDM(data.obj$dat, MQ)
validation.obj <- validation(data.obj$dat, MQ, CDM.obj2, 
                             method = "GDI")
summary(validation.obj)

validation.updated <- update(validation.obj, method = "Hull")
summary(validation.updated)


################################################################
# Example 3: summary a sim.data object                         #
################################################################
data.obj2 <- sim.data(Q = sim.Q(3, 10), N = 1000)
summary(data.obj2)

data.updated <- update(data.obj2, N = 200)
summary(data.updated)


################################################################
# Example 4: summary a fit object                              #
################################################################
fit.obj <- fit(data.obj$dat, Q, model = "GDINA")
summary(fit.obj)

data.updated <- update(fit.obj, model = "DINA")
summary(data.updated)
}

}
