/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public final class CheckboxListTableModel<T>
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CheckboxListTableModel.class.getName());
    private Object[][] items = new Object[0][];

    public void setItems(Map<String, String> map) {
        Object[][] objectArrayArray = new Object[map.size()][];
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            objectArrayArray[n++] = new Object[]{false, entry.getKey(), entry.getValue()};
        }
        this.items = objectArrayArray;
        this.fireTableStructureChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return n == 0 ? Boolean.class : String.class;
    }

    public Collection<String> getCheckedCodes() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < this.items.length; ++i) {
            if (!((Boolean)this.items[i][0]).booleanValue()) continue;
            linkedList.add((String)this.items[i][1]);
        }
        return linkedList;
    }

    public void updateCheckedCodes(Collection<String> collection) {
        for (int i = 0; i < this.items.length; ++i) {
            if (!collection.contains((String)this.items[i][1])) continue;
            this.items[i][0] = new Boolean(true);
        }
    }

    public int getCheckedCodesCount() {
        int n = 0;
        for (int i = 0; i < this.items.length; ++i) {
            if (!((Boolean)this.items[i][0]).booleanValue()) continue;
            ++n;
        }
        return n;
    }

    public void uncheckAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.setValueAt(false, i, 0);
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.items.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            return this.items[n][n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return n2 == 0 ? Boolean.FALSE : "";
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.items[n][n2] = object;
        this.fireTableCellUpdated(n, n2);
    }

    public void clear() {
        this.uncheckAll();
        this.items = new Object[0][];
        this.fireTableStructureChanged();
    }
}

