% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMVL.R
\name{mvl_hash_vectors}
\alias{mvl_hash_vectors}
\title{Return hash values for each row}
\usage{
mvl_hash_vectors(L, indices = NULL)
}
\arguments{
\item{L}{list of vector like MVL_OBJECTs}

\item{indices}{list of indices into objects to sort. If absent or NULL it is assumed to be from 1 to the length of the object.}
}
\value{
hash values in numeric format, with 52 valid bits. Each value is uniform between 1 and 2.
}
\description{
This function is passed a list of MVL vectors which are interpreted in data.frame fashion. For each row, i.e. set of vector values with the same index
we compute a hash value. Identical rows produce identical hash values. The hash values have good entropy and can be used to map row values into random numbers.
}
\examples{
\dontrun{
Mtmp<-mvl_open("tmp_a.mvl", append=TRUE, create=TRUE)
mvl_write_object(Mtmp, runif(100), "vec1")
Mtmp<-mvl_remap(Mtmp)
hash1<-mvl_hash_vectors(list(Mtmp["vec1", ref=TRUE]))
}
}
\seealso{
\code{\link{mvl_order_vectors}}, \code{\link{mvl_find_matches}}, \code{\link{mvl_group}}, \code{\link{mvl_find_matches}}, \code{\link{mvl_indexed_copy}}, \code{\link{mvl_merge}}, \code{\link{mvl_write_hash_vectors}}
}
