#'  Memory Experiment Data Description from MacKinnon et al., 2018
#'
#' Data were obtained from eight replicated experiments. The data were collected on the first day of class as part of the first Dr. MacKinnon's (2018) classroom teaching. The pedagogical value of the experiment was that students would have first-hand knowledge of the experiment thereby increasing their understanding of course concepts. Permission to use the data was obtained from the university Institutional Review Board.
#'
#' @format A data frame with 369 rows and 5 variables:
#' \describe{
#'   \item{study}{Replication ID, ranges from 1 to 8}
#'   \item{repetition}{Use of repetition rehearsal technique on a 1 to 9 scale}
#'   \item{recall}{Total words recalled out of 20 words}
#'   \item{imagery}{Use of imagery rehearsal technique on a 1 to 9 scale}
#'   \item{x}{A \link{factor} with two levels: repetition or primary rehearsal = 0, imagery or secondary rehearsal = 1}
#' }
#' @usage data(memory_exp)
#' @docType data
#' @keywords data sets
#' @note If you use the data set, please cite the original article by MacKinnon et al. (2018) cited below.
#' @references MacKinnon, D. P., Valente, M. J., & Wurpts, I. C. (2018). Benchmark validation of statistical models: Application to mediation analysis of imagery and memory. Psychological Methods, 23, 654–671. \doi{https://doi.org/10.1037/met0000174}
#' @source \doi{http://dx.doi.org/10.1037/met0000174.supp}
"memory_exp"
