% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trunct.R
\name{trunct}
\alias{trunct}
\alias{dtrunct}
\alias{ptrunct}
\alias{qtrunct}
\alias{rtrunct}
\title{Truncated t distribution}
\usage{
dtrunct(x, df, min = -Inf, max = Inf, log = FALSE)

ptrunct(q, df, min = -Inf, max = Inf, lower.tail = TRUE, log.p = FALSE)

qtrunct(p, df, min = -Inf, max = Inf, lower.tail = TRUE, log.p = FALSE)

rtrunct(n, df, min = -Inf, max = Inf)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{df}{degrees of freedom parameter, must be positive.}

\item{min, max}{truncation bounds.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{number of random values to return.}
}
\value{
\code{dtrunct} gives the density, \code{ptrunct} gives the distribution function,
\code{qtrunct} gives the quantile function, and \code{rtrunct} generates random deviates.
}
\description{
Density, distribution function, quantile function, and random generation for
the truncated t distribution.
}
\details{
This implementation of \code{dtrunct} allows for automatic differentiation with \code{RTMB}.
}
\examples{
x <- rtrunct(1, df = 5, min = -1, max = 5)
d <- dtrunct(x, df = 5, min = -1, max = 5)
p <- ptrunct(x, df = 5, min = -1, max = 5)
q <- qtrunct(p, df = 5, min = -1, max = 5)
}
