% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwtbl_helpers.R
\name{rwtbl_var_to_slot}
\alias{rwtbl_var_to_slot}
\title{Map a variable name to the RiverWare slot name}
\usage{
rwtbl_var_to_slot(rwtblsmmry, varname)
}
\arguments{
\item{rwtblsmmry}{A tbl_df of summarized RiverWare data; likely output from
\code{\link[=rw_scen_aggregate]{rw_scen_aggregate()}}.}

\item{varname}{A vector of variable names to map to slot names.}
}
\value{
A character vector of the found slot names. \code{character(0)} if no
variable names were found.
}
\description{
\code{rwtbl_var_to_slot()} provides the RiverWare slot name that was used to
create the specified variable name (\code{varname}). If \code{varname} is not found in
\code{rwtblsmmry}, a warning message is posted.
}
\examples{
rwtbl_var_to_slot(scen_data, "peLt1000")
rwtbl_var_to_slot(scen_data, c("peLt1000", "peEocy"))

}
