% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_table_body_func.R
\name{modify_table_body_func}
\alias{modify_table_body_func}
\title{Modify Table Body}
\usage{
modify_table_body_func(data)
}
\arguments{
\item{data}{A data frame that contains columns named \verb{stat_*} and optionally
\verb{add_n_stat_*}. The function assumes that \verb{stat_*} columns are to be updated using
\verb{add_n_stat_*} columns when necessary.}
}
\value{
A modified data frame where:
\itemize{
\item \verb{stat_*} columns are updated to replace \code{NA} values with the corresponding values
from \verb{add_n_stat_*}.
\item \verb{add_n_stat_*} columns are removed after processing.
\item If no \verb{add_n_stat_*} columns exist, these columns are simply removed.
}
}
\description{
This function modifies a table by updating the "stat_\emph{" columns with corresponding
"add_n_stat_}" columns if they exist. If "stat_\emph{" columns contain missing values
(\code{NA}), the function replaces them with the respective "add_n_stat_}" column values.
Extra "add_n_stat_*" columns are removed after processing.
}
\details{
\itemize{
\item The function identifies columns starting with "add_n_stat_" and attempts to use them
to fill missing values in columns matching the pattern "^stat_\\d+$".
\item If all required "add_n_stat_*" columns exist in \code{data}, they are utilized for this
replacement; otherwise, the \verb{add_n_stat_*} columns are removed without modifications
to the \verb{stat_*} columns.
}
}
\examples{
# Example data
data <- data.frame(
  n = c(1, 2, 3),
  stat_1 = c(NA, 5, 6),
  stat_2 = c(7, NA, 9),
  add_n_stat_1 = c(10, 11, 12),
  add_n_stat_2 = c(13, 14, 15)
)

# Apply the function
modified_data <- modify_table_body_func(data)
print(modified_data)

}
