% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pvalues.R
\name{add_pvalues}
\alias{add_pvalues}
\title{Add p-values and separate footnotes to a gtsummary object}
\usage{
add_pvalues(res, tests)
}
\arguments{
\item{res}{A \code{gtsummary} table object.}

\item{tests}{A list of tests to pass to \code{gtsummary::add_p()}, or \code{TRUE} to use default tests.}
}
\value{
A \code{gtsummary} table object with p-values added and footnotes separated.
}
\description{
This function adds p-values to a gtsummary table using the specified tests
and separates the p-value footnotes.
}
\examples{
library(gtsummary)
tbl <- trial \%>\% tbl_summary(by = trt)
tbl <- add_pvalues(tbl, tests = TRUE)

}
