% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_ei_per_pt.R
\name{desc_ei_per_pt_prepare_df}
\alias{desc_ei_per_pt_prepare_df}
\title{Prepare Data for AE Description by SOC and PT}
\usage{
desc_ei_per_pt_prepare_df(
  augmented_df_pat_grp,
  augmented_df_pat_pt_grp,
  order_by_freq = TRUE,
  unknown_ei = " Unknown",
  digits = 1
)
}
\arguments{
\item{augmented_df_pat_grp}{A dataframe containing patient IDs and group assignments, including a "Total" group.}

\item{augmented_df_pat_pt_grp}{A dataframe linking patient IDs to SOC and PT, with group assignments.}

\item{order_by_freq}{Logical. Should PT and SOC be ordered by frequency? Defaults to TRUE. If FALSE, PT and SOC are ordered alphabetically.}

\item{unknown_ei}{How the unknown adverse event is labelled.}

\item{digits}{Number of digits for percentages}
}
\value{
A wide-format dataframe summarizing adverse event occurrences and patient counts across groups.
}
\description{
This function processes patient and adverse event data to generate a wide-format summary dataframe,
including total counts and percentages of events and patients per SOC (System Organ Class) and PT (Preferred Term).
}
\keyword{internal}
