% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistanceBetweenGroups.R
\name{DistanceBetweenGroups}
\alias{DistanceBetweenGroups}
\title{Distance between groups}
\usage{
DistanceBetweenGroups(group1, group2, FHW_output, distance, data)
}
\arguments{
\item{group1}{Number. Number of the first group.}

\item{group2}{Number. Number of the second group.}

\item{FHW_output}{List. Output of the \code{Hartigan_and_Wong} function. List with:

\itemize{
  \item centers: the information of the centers updated.
  \item grouping: the information of the groups updated. List. Each component of the list contains a vector with the points that belong to that group. More specifically, the list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.
   }}

\item{distance}{Function. This function designs how the distance is going to be calculated. It must have as input two vectors and as output the distance of these vectors.}

\item{data}{Matrix with \code{dim(data)[1]} points of \code{dim(data)[2]} dimensions.}
}
\value{
Returns a number, the value of the minimum distance between pair of points of the two groups.
}
\description{
This function calculates the distance between points in two groups. For each point in the first group, it calculates the distance from that point to all points in the second group.  Finally, it takes the minimum distance obtained.
}
\examples{

set.seed(451)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),
         matrix(runif(20,20,30), nrow = 2, ncol = 10),
         matrix(runif(20,50,70), nrow = 2, ncol = 10))
k=3
seed=5


FHW_output=Hartigan_and_Wong(data,
                            Euclideandistance,
                            k,
                            centers_function_mean,
                            init_centers_random,
                            seed=seed,
                            10)

DistanceBetweenGroups(1, 2, FHW_output, Euclideandistance, data)

}
