#we compare with the kmeans function
##############
set.seed(451)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),matrix(runif(20,20,30), nrow = 2, ncol = 10),matrix(runif(20,50,70), nrow = 2, ncol = 10))
k=3
seed=5

distance<- function(vect1, vect2){
  sqrt(sum((vect1-vect2)^2))
}

centers_function<-function(data, grouping){
  center=matrix(0,length(grouping), dim(data)[2])
  for (i in 1:(length(grouping))){

    if(length(grouping[[i]])==1){
      center[i,]=data[grouping[[i]],]
    }else{
      center[i,]=apply(data[grouping[[i]],],2,mean)
    }
  }
  return(center)
}
init_centers=init_centers_random

#with kmeans
if(!is.null(seed)){
  set.seed(seed)
}
centers <- data[sample(1:nrow(data), k), ]
kmeas_R=kmeans(data,centers, 10, algorithm ="Hartigan-Wong")
dimnames(kmeas_R$centers) <- NULL

#With our function
P6=Hartigan_and_Wong(data, distance,k,centers_function,init_centers,seed=seed, 10)
vector=c()
for (ii in 1:dim(data)[1]){
  vector[ii]=encontrar_componente(P6$grouping, ii)
}


#We make sure they are the same
test_that("Hartigan_and_Wong", {
  expect_equal(P6$centers,  kmeas_R$centers,tolerance=1e-6)
  expect_equal(vector, kmeas_R$cluster,tolerance=1e-6)
})


############
#Anther test
##############
set.seed(51)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),matrix(runif(20,20,30), nrow = 2, ncol = 10),matrix(runif(20,50,70), nrow = 2, ncol = 10), matrix(runif(20,100,120), nrow = 2, ncol = 10))
k=4
seed=5

distance<- function(vect1, vect2){
  sqrt(sum((vect1-vect2)^2))
}

centers_function<-function(data, grouping){
  center=matrix(0,length(grouping), dim(data)[2])
  for (i in 1:(length(grouping))){

    if(length(grouping[[i]])==1){
      center[i,]=data[grouping[[i]],]
    }else{
      center[i,]=apply(data[grouping[[i]],],2,mean)
    }
  }
  return(center)
}

#With kmeans
if(!is.null(seed)){
  set.seed(seed)
}
centers <- data[sample(1:nrow(data), k), ]
kmeas_R=kmeans(data,centers, 10, algorithm ="Hartigan-Wong")
dimnames(kmeas_R$centers) <- NULL

#With our function
P6=Hartigan_and_Wong(data, distance,k,centers_function,init_centers,seed=seed, 10)
vector=c()
for (ii in 1:dim(data)[1]){
  vector[ii]=encontrar_componente(P6$grouping, ii)
}

#We make sure they are the same
test_that("Hartigan_and_Wong", {
  expect_equal(P6$centers,  kmeas_R$centers,tolerance=1e-6)
  expect_equal(vector, kmeas_R$cluster,tolerance=1e-6)
})


############
#Another test
##############
set.seed(721)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),matrix(runif(20,20,30), nrow = 2, ncol = 10))
k=2
seed=5

distance<- function(vect1, vect2){
  sqrt(sum((vect1-vect2)^2))
}

centers_function<-function(data, grouping){
  center=matrix(0,length(grouping), dim(data)[2])
  for (i in 1:(length(grouping))){

    if(length(grouping[[i]])==1){
      center[i,]=data[grouping[[i]],]
    }else{
      center[i,]=apply(data[grouping[[i]],],2,mean)
    }
  }
  return(center)
}

#With kmeans
if(!is.null(seed)){
  set.seed(seed)
}
centers <- data[sample(1:nrow(data), k), ]
kmeas_R=kmeans(data,centers, 10, algorithm ="Hartigan-Wong")
dimnames(kmeas_R$centers) <- NULL

#With our function
P6=Hartigan_and_Wong(data, distance,k,centers_function,init_centers, seed=seed, 10)
vector=c()
for (ii in 1:dim(data)[1]){
  vector[ii]=encontrar_componente(P6$grouping, ii)
}

#We make sure they are the same
test_that("Hartigan_and_Wong", {
  expect_equal(P6$centers,  kmeas_R$centers,tolerance=1e-6)
  expect_equal(vector, kmeas_R$cluster,tolerance=1e-6)
})


############################################
#Another test
############################################
set.seed(516)
data=rbind(matrix(runif(60,1,30), nrow = 6, ncol = 10))
k=3
seed=5

distance<- function(vect1, vect2){
  sqrt(sum((vect1-vect2)^2))
}

centers_function<-function(data, grouping){
  center=matrix(0,length(grouping), dim(data)[2])
  for (i in 1:(length(grouping))){

    if(length(grouping[[i]])==1){
      center[i,]=data[grouping[[i]],]
    }else{
      center[i,]=apply(data[grouping[[i]],],2,mean)
    }
  }
  return(center)
}


#With kmeans
if(!is.null(seed)){
  set.seed(seed)
}
centers <- data[sample(1:nrow(data), k), ]
kmeas_R=kmeans(data,centers, iter.max=10, algorithm ="Hartigan-Wong")#1 1 3 3 2 2
dimnames(kmeas_R$centers) <- NULL

#With our function
P6=Hartigan_and_Wong(data, distance,k,centers_function,init_centers,seed=seed, 10)
vector=c()
for (ii in 1:dim(data)[1]){
  vector[ii]=encontrar_componente(P6$grouping, ii)
}


#We make sure they are the same
test_that("Hartigan_and_Wong", {
  expect_equal(P6$centers,  kmeas_R$centers,tolerance=1e-6)
  expect_equal(vector, kmeas_R$cluster,tolerance=1e-6)
})


####################################
#Another test
######################################
set.seed(451)
data=rbind(matrix(runif(60,1,30), nrow = 6, ncol = 10))
k=3
seed=5

distance<- function(vect1, vect2){
  sqrt(sum((vect1-vect2)^2))
}

centers_function<-function(data, grouping){
  center=matrix(0,length(grouping), dim(data)[2])
  for (i in 1:(length(grouping))){

    if(length(grouping[[i]])==1){
      center[i,]=data[grouping[[i]],]
    }else{
      center[i,]=apply(data[grouping[[i]],],2,mean)
    }
  }
  return(center)
}


#With kmeans
if(!is.null(seed)){
  set.seed(seed)
}
centers <- data[sample(1:nrow(data), k), ]
kmeas_R=kmeans(data,centers, iter.max=10, algorithm ="Hartigan-Wong")#1 1 3 3 2 2
dimnames(kmeas_R$centers) <- NULL

#With our function
P6=Hartigan_and_Wong(data, distance,k,centers_function,init_centers, seed=seed, 10)
vector=c()
for (ii in 1:dim(data)[1]){
  vector[ii]=encontrar_componente(P6$grouping, ii)
}


#We make sure they are the same
test_that("Hartigan_and_Wong", {
  expect_equal(P6$centers,  kmeas_R$centers,tolerance=1e-6)
  expect_equal(vector, kmeas_R$cluster,tolerance=1e-6)
})


####################################
#Another test: dataset real
######################################
set.seed(451)
data=iris[,-5]
k=3
seed=5


distance<- function(vect1, vect2){
  sqrt(sum((vect1-vect2)^2))
}

centers_function<-function(data, grouping){
  center=matrix(0,length(grouping), dim(data)[2])
  for (i in 1:(length(grouping))){

    if(length(grouping[[i]])==1){
      center[i,]=data[grouping[[i]],]
    }else{
      center[i,]=apply(data[grouping[[i]],],2,mean)
    }
  }
  return(center)
}


#With kmeans
if(!is.null(seed)){
  set.seed(seed)
}
centers <- data[sample(1:nrow(data), k), ]
kmeas_R=kmeans(data,centers, iter.max=10, algorithm ="Hartigan-Wong")#1 1 3 3 2 2
dimnames(kmeas_R$centers) <- NULL

#With our function
P6=Hartigan_and_Wong(data, distance,k,centers_function,init_centers, seed=seed, 10)
vector=c()
for (ii in 1:dim(data)[1]){
  vector[ii]=encontrar_componente(P6$grouping, ii)
}


#We make sure they are the same
test_that("Hartigan_and_Wong", {
  expect_equal(P6$centers,  kmeas_R$centers,tolerance=1e-6)
  expect_equal(vector, kmeas_R$cluster,tolerance=1e-6)
})


