% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_utils.R
\name{fit_to_df}
\alias{fit_to_df}
\title{a one-row overview of a fuzzy system with the usage of variables, the fitness, number of generations and optionally
a metric}
\usage{
fit_to_df(fit, metric = NULL)
}
\arguments{
\item{fit}{a fit object, as returned by [fit.}

\item{metric}{an optional metric name to report (e.g. \code{rmse})}
}
\value{
a one-row data frame
}
\description{
a one-row overview of a fuzzy system with the usage of variables, the fitness, number of generations and optionally
a metric
}
\examples{
model <- fuzzycoco("regression", example_mtcars()$params, seed = 123)
df <- mtcars[c("mpg", "hp", "wt", "qsec")]
fit <- fit(model, qsec ~ ., df, seed = 456, max_generations = 10, progress = FALSE)

print(fit_to_df(fit))
}
\seealso{
Other fit_utils: 
\code{\link{fs_rules_to_df}()},
\code{\link{fs_used_vars_to_df}()}
}
\concept{fit_utils}
