% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_outcome_scb.R
\name{SCB_regression_coef}
\alias{SCB_regression_coef}
\title{Construct Simultaneous Confidence Bands for Regression Coefficients}
\usage{
SCB_regression_coef(
  df_fit,
  model,
  n_boot = 5000,
  alpha = 0.05,
  type = "linear"
)
}
\arguments{
\item{df_fit}{A data frame containing the design matrix and response variable used to fit the model.}

\item{model}{A character string specifying the regression formula (e.g., \code{"y ~ x1 + x2"}).}

\item{n_boot}{Integer. Number of bootstrap samples to use for constructing the SCBs. Default is 5000.}

\item{alpha}{Numeric. Significance level for the confidence bands (e.g., 0.05 for 95\% SCBs). Default is 0.05.}

\item{type}{A character string specifying the model type. Either \code{"linear"} (default) or \code{"logistic"}.}
}
\value{
A data frame with the following columns:
\describe{
\item{scb_low}{Lower bound of the simultaneous confidence band.
The first row corresponds to the intercept, and subsequent rows correspond to regression coefficients.}
\item{Mean}{Estimated values. The first element is the intercept estimate, and the remaining are coefficient estimates.}
\item{scb_up}{Upper bound of the simultaneous confidence band.
The first row corresponds to the intercept, and subsequent rows correspond to regression coefficients.}
}
}
\description{
This function fits either a linear or logistic regression model and computes simultaneous confidence bands (SCBs)
for the model coefficients using a non-parametric bootstrap procedure.
}
\examples{
library(MASS)
set.seed(262)
M <- 5
rho <- 0.4
n <- 100
beta <- rnorm(M, mean = 0, sd = 1)
Sigma <- outer(1:M, 1:M, function(i, j) rho^abs(i - j))
X <- MASS::mvrnorm(n = n, mu = rep(0, M), Sigma = Sigma)
epsilon <- rnorm(n, mean = 0, sd = 1)
y <- X \%*\% beta + epsilon
df <- as.data.frame(X)
names(df) <- paste0("x", 1:M)
df$y <- as.vector(y)
model <- "y ~ ."
results <- SCB_regression_coef(df, model, n_boot = 100)

}
\references{
Ren, J., Telschow, F. J. E., & Schwartzman, A. (2024).
Inverse set estimation and inversion of simultaneous confidence intervals.
\emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)}, 73(4), 1082–1109.
\doi{10.1093/jrsssc/qlae027}
}
