% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_temperature.R
\name{generate_temperature}
\alias{generate_temperature}
\title{Generate Geometric Inverse-Temperature Ladder
Constructs a geometric sequence of temperatures (inverse temperatures)
for parallel-tempering MCMC.}
\usage{
generate_temperature(N_chain, T_max = 10)
}
\arguments{
\item{N_chain}{Number of parallel chains (N_chain > 1).}

\item{T_max}{Highest temperature (coldest chain).  Default is 10.}
}
\value{
A numeric vector of length N_chain containing the
        geometrically spaced temperatures.
}
\description{
Generate Geometric Inverse-Temperature Ladder
Constructs a geometric sequence of temperatures (inverse temperatures)
for parallel-tempering MCMC.
}
\examples{
set.seed(1)
temps <- generate_temperature(N_chain = 8, T_max = 10)
print(temps)
}
