% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_logical.R
\name{check_zero_positions}
\alias{check_zero_positions}
\title{Identify samples with zero-valued station coordinates}
\usage{
check_zero_positions(
  data,
  coord = "longitude",
  return_df = FALSE,
  return_logical = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{data}{A data frame. Must contain \code{sample_longitude_dd} and/or \code{sample_latitude_dd}.}

\item{coord}{Character. Which coordinate(s) to check: "longitude", "latitude", or "both". Default = "longitude".}

\item{return_df}{Logical. If TRUE, return a plain data.frame of problematic rows
instead of a DT datatable. Default = FALSE.}

\item{return_logical}{Logical. If TRUE, return a logical vector of length nrow(data)
indicating which rows have zero in the selected coordinate(s). Overrides return_df. Default = FALSE.}

\item{verbose}{Logical. If TRUE, messages will be displayed during execution. Defaults to TRUE.}
}
\value{
A DT datatable, a data.frame, a logical vector, or NULL (if no problems found
and return_logical = FALSE).
}
\description{
This function inspects a dataset containing sample coordinates to identify
potential issues where longitude or latitude values are zero (0), which typically
indicate missing or erroneous station positions. The function can return a summary
table, a filtered data frame, or a logical vector highlighting problematic rows.
It is useful as a data quality control step before spatial analyses or database imports.
}
\examples{
# Example data
df <- data.frame(
  station_name = c("A", "B", "C"),
  sample_longitude_dd = c(15.2, 0, 18.7),
  sample_latitude_dd = c(56.3, 58.1, 0)
)

# Check for zeroes in both coordinates and return as data.frame
check_zero_positions(df, coord = "both", return_df = TRUE)

# Return a logical vector instead of a table
check_zero_positions(df, coord = "both", return_logical = TRUE)

}
