% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_delivery_template.R
\name{find_required_fields}
\alias{find_required_fields}
\title{Find required fields in a SHARK delivery template}
\usage{
find_required_fields(
  datatype,
  stars = 1,
  bacterioplankton_subtype = "abundance"
)
}
\arguments{
\item{datatype}{Character. The datatype name.
Available options include:
\itemize{
\item "Bacterioplankton" (subtypes: "abundance", "production")
\item "Chlorophyll"
\item "Epibenthos" (dive transect)
\item "Dropvideo" (epibenthos drop video)
\item "Grey seal"
\item "Harbour seal"
\item "Ringed seal"
\item "Harbour Porpoise"
\item "Physical and Chemical"
\item "Primary production"
\item "Phytoplankton"
\item "Picoplankton"
\item "Sedimentation"
\item "Seal pathology"
\item "Profile"
\item "Zooplankton"
\item "Zoobenthos"
}}

\item{stars}{Integer. Maximum number of "\emph{" levels to include.
Default = 1 (only single "}").
For example, \code{stars = 2} includes "\emph{" and "**",
\code{stars = 3} includes "}", "\strong{", and "}*".}

\item{bacterioplankton_subtype}{Character. For "Bacterioplankton" only: either
"abundance" (default) or "production". Ignored for other datatypes.}
}
\value{
A character vector of column names that are required in the template.
}
\description{
Identifies which columns are mandatory in the SHARK delivery template based on
rows starting with "*" (one or more). You can specify how many levels of
asterisks to include.
}
\details{
Note: A single "*" marks required fields in the standard SHARK template.
A double "**" is often used to specify columns required for \strong{national monitoring only}.
For more information, see:
https://www.smhi.se/data/hav-och-havsmiljo/datavardskap-oceanografi-och-marinbiologi/leverera-data
}
\examples{
\donttest{
# Only single "*" required columns
find_required_fields("Bacterioplankton")

# Include both "*" and "**" required columns (national monitoring too)
find_required_fields("Bacterioplankton", stars = 2)

# Include up to three levels of "*"
find_required_fields("Phytoplankton", stars = 3)
}

}
