% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algaebase_api_functions.R
\name{match_algaebase}
\alias{match_algaebase}
\title{Search AlgaeBase for taxonomic information}
\usage{
match_algaebase(
  genus,
  species,
  subscription_key = Sys.getenv("ALGAEBASE_KEY"),
  genus_only = FALSE,
  higher = TRUE,
  unparsed = FALSE,
  exact_matches_only = TRUE,
  sleep_time = 1,
  newest_only = TRUE,
  verbose = TRUE,
  apikey = deprecated()
)
}
\arguments{
\item{genus}{A character vector of genus names.}

\item{species}{A character vector of species names corresponding to the \code{genus} vector. Must be the same length as \code{genus}.}

\item{subscription_key}{A character string containing the API key for accessing the AlgaeBase API. By default, the key
is read from the environment variable \code{ALGAEBASE_KEY}.

You can provide the key in three ways:
\itemize{
\item \strong{Directly as a parameter}:
\code{match_algaebase("Skeletonema", "marinoi", subscription_key = "your_key_here")}.
\item \strong{Temporarily for the session}:
\code{Sys.setenv(ALGAEBASE_KEY = "your_key_here")}.
After this, you do not need to pass \code{subscription_key} to the function.
\item \strong{Permanently across sessions} by adding it to your \code{~/.Renviron} file.
Use \code{usethis::edit_r_environ()} to open the file, then add:
\code{ALGAEBASE_KEY=your_key_here}.
After this, you do not need to pass \code{subscription_key} to the function.
}}

\item{genus_only}{Logical. If \code{TRUE}, searches are based solely on the genus name, ignoring species. Defaults to \code{FALSE}.}

\item{higher}{Logical. If \code{TRUE}, includes higher taxonomy (e.g., kingdom, phylum) in the output. Defaults to \code{TRUE}.}

\item{unparsed}{Logical. If \code{TRUE}, returns raw JSON output instead of a \code{tibble}. Defaults to \code{FALSE}.}

\item{exact_matches_only}{Logical. If \code{TRUE}, restricts results to exact matches. Defaults to \code{TRUE}.}

\item{sleep_time}{Numeric. The delay (in seconds) between consecutive AlgaeBase API queries. Defaults to \code{1}. A delay is recommended to avoid overwhelming the API for large queries.}

\item{newest_only}{A logical value indicating whether to return only the most recent entries (default is \code{TRUE}).}

\item{verbose}{Logical. If \code{TRUE}, displays a progress bar to indicate query status. Defaults to \code{TRUE}.}

\item{apikey}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{subscription_key} instead.}
}
\value{
A \code{tibble} containing taxonomic information for each input genus–species combination.
The following columns may be included:
\itemize{
\item \code{id} — AlgaeBase ID (if available).
\item \code{kingdom}, \code{phylum}, \code{class}, \code{order}, \code{family} — Higher taxonomy (returned if \code{higher = TRUE}).
\item \code{genus}, \code{species}, \code{infrasp} — Genus, species, and infraspecies names (if applicable).
\item \code{taxonomic_status} — Status of the name (e.g., accepted, synonym, unverified).
\item \code{currently_accepted} — Logical indicator whether the name is currently accepted (\code{TRUE}/\code{FALSE}).
\item \code{accepted_name} — Currently accepted name if different from the input name.
\item \code{input_name} — The name supplied by the user.
\item \code{input_match} — Indicator of exact match (\code{1} = exact, \code{0} = not exact).
\item \code{taxon_rank} — Taxonomic rank of the accepted name (e.g., genus, species).
\item \code{mod_date} — Date when the entry was last modified in AlgaeBase.
\item \code{long_name} — Full species name with authorship and date.
\item \code{authorship} — Author(s) associated with the species name.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function has been deprecated. Users are encouraged to use \code{\link{match_algaebase_taxa}} instead.

This function queries the AlgaeBase API to retrieve taxonomic information for a list of algae names based on genus and (optionally) species.
It supports exact matching, genus-only searches, and retrieval of higher taxonomic ranks.
}
\details{
A valid API key is requested from the AlgaeBase team.

Scientific names can be parsed using the \code{parse_scientific_names()} function before being processed by \code{match_algaebase()}.

Duplicate genus-species combinations are handled efficiently by querying each unique combination only once. Genus-only searches are performed when \code{genus_only = TRUE}
or when the species name is missing or invalid. Errors during API queries are gracefully handled by returning rows with \code{NA} values for missing or unavailable data.

The function allows for integration with data analysis workflows that require resolving or verifying taxonomic names against AlgaeBase.
}
\examples{
\dontrun{
# Example with genus and species vectors
genus_vec <- c("Thalassiosira", "Skeletonema", "Tripos")
species_vec <- c("pseudonana", "costatum", "furca")

algaebase_results <- match_algaebase(
  genus = genus_vec,
  species = species_vec,
  subscription_key = "your_api_key",
  exact_matches_only = TRUE,
  verbose = TRUE
)
head(algaebase_results)
}
}
\seealso{
\url{https://www.algaebase.org/} for AlgaeBase website.

\code{\link{parse_scientific_names}}
}
\keyword{internal}
