% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.SLOPE}
\alias{plot.SLOPE}
\title{Plot Coefficients}
\usage{
\method{plot}{SLOPE}(
  x,
  intercept = FALSE,
  x_variable = c("alpha", "deviance_ratio", "step"),
  magnitudes = FALSE,
  add_labels = FALSE,
  mark_zero = TRUE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{"SLOPE"}}

\item{intercept}{whether to plot the intercept}

\item{x_variable}{what to plot on the x axis. \code{"alpha"} plots
the scaling parameter for the sequence, \code{"deviance_ratio"} plots
the fraction of deviance explained, and \code{"step"} plots step number.}

\item{magnitudes}{whether to plot the magnitudes of the coefficients}

\item{add_labels}{whether to add labels (numbers) on the right side
of the plot for each coefficient (only used when the path contains multiple
solutions)}

\item{mark_zero}{whether to add a vertical line at zero in the dot chart
(only used when the path contains a single solution)}

\item{...}{for multiple solutions: arguments passed to \code{\link[graphics:matplot]{graphics::matplot()}}.
For a single solution: arguments passed to \code{\link[graphics:dotchart]{graphics::dotchart()}}.}
}
\value{
Invisibly returns NULL. The function is called for its
side effect of producing a plot.
}
\description{
Plot the fitted model's regression
coefficients along the regularization path. When the path contains a single
solution (only one alpha value), a dot chart is displayed showing the
coefficient values. When the path contains multiple solutions, a line plot
is displayed showing how coefficients evolve along the regularization path.
}
\examples{
# Multiple solutions along regularization path
fit <- SLOPE(heart$x, heart$y)
plot(fit)

# Single solution with dot chart
fit_single <- SLOPE(heart$x, heart$y, alpha = 0.1)
plot(fit_single)

# Single solution for multinomial regression
fit_multi <- SLOPE(wine$x, wine$y, family = "multinomial", alpha = 0.05)
plot(fit_multi)
}
\seealso{
\code{\link[=SLOPE]{SLOPE()}}, \code{\link[=plotDiagnostics]{plotDiagnostics()}}

Other SLOPE-methods: 
\code{\link{coef.SLOPE}()},
\code{\link{deviance.SLOPE}()},
\code{\link{predict.SLOPE}()},
\code{\link{print.SLOPE}()},
\code{\link{score}()},
\code{\link{summary.SLOPE}()}
}
\concept{SLOPE-methods}
