test_that("simul_fun_noGEV_3d runs correctly with valid inputs", {
  set.seed(3)
  n_train <- 20; n_test <- 3; M <- 2
  y_tr <- rnorm(n_train); y_te <- rnorm(n_test)
  z_tr <- matrix(rnorm(n_train * M), ncol = M)
  z_te <- matrix(rnorm(n_test * M),  ncol = M)
  # Simple wrappers if your API expects lists per region:
  y_train <- list("A" = y_tr, "B" = y_tr, "C" = y_tr)
  y_test  <- list("A" = y_te, "B" = y_te, "C" = y_te)
  z_train <- list(z_tr, z_tr, z_tr); z_test <- list(z_te, z_te, z_te)
  u <- list(pnorm(scale(y_tr)), pnorm(scale(y_tr)), pnorm(scale(y_tr)))
  X_t <- z_tr

  b1 <- STCYP::fit_bsts(y_train[[1]], z_train[[1]], lags = 1, MCMC.iter = 20)
  b2 <- STCYP::fit_bsts(y_train[[2]], z_train[[2]], lags = 1, MCMC.iter = 20)
  b3 <- STCYP::fit_bsts(y_train[[3]], z_train[[3]], lags = 1, MCMC.iter = 20)

  out <- STCYP::simul_fun_noGEV_3d(
    nsim = 2, n_train = n_train, n_test = n_test,
    copula = "Gaussian", init_params = c(0, 0.4, rep(0.1, M)),
    fn = STCYP::log_likelihood_noGEV_3d,
    u1 = u[[1]], u2 = u[[2]], u3 = u[[3]],
    z1_train = z_train[[1]], z2_train = z_train[[2]], z3_train = z_train[[3]],
    z1_test = z_test[[1]],  z2_test  = z_test[[2]],  z3_test  = z_test[[3]],
    X_t = X_t, y1_test = y_test[[1]], y2_test = y_test[[2]], y3_test = y_test[[3]],
    BSTS_1 = b1, BSTS_2 = b2, BSTS_3 = b3
  )
  expect_type(out, "list")
  expect_equal(length(out), 6)
})
