% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TBA.R
\name{TBA}
\alias{TBA}
\title{TBA}
\usage{
TBA(P_targeted = NULL, rb = NULL, digits = 2, plot = FALSE)
}
\arguments{
\item{P_targeted}{Numeric (length 1) in [0, 1]. Proportion of abundance targeted
by harvest slot limits (e.g., from \code{prop_target()}).}

\item{rb}{Numeric (length 1). Proportional rate of change in a biomass index
(e.g., from \code{rb()}). Typical values lie in [-1, 1], but larger magnitudes are allowed.}

\item{digits}{Integer. Number of decimal places used to round outputs
(default = 2). Set \code{digits = NA} to prevent rounding.}

\item{plot}{Logical. If \code{TRUE}, include a \pkg{ggplot2} plot of the calculated value
on a grid of (\code{P_targeted}, \code{rb}) combinations (default \code{FALSE}).}
}
\value{
A list with:
\describe{
\item{P_targeted}{Input targeted proportion (numeric scalar).}
\item{rb}{Input proportional rate of change (numeric scalar).}
\item{damped_change}{\eqn{P_{\mathrm{targeted}} \times rb} (numeric scalar).}
\item{TBA}{Targeted biomass adjustment multiplier \eqn{1 + P_{\mathrm{targeted}} \times rb}
(numeric scalar). \code{TBA > 1} increases advised catch; \code{TBA < 1} decreases it.}
\item{plot}{(only when \code{plot=TRUE}) a \pkg{ggplot2} object visualizing TBA over a grid.}
}
}
\description{
Calculate the targeted biomass adjustment (TBA), which dampens the influence
of proportional rate of change \eqn{rb} on catch advice when the proportion of abundance
targeted by harvest slot limits is small. Optionally, produce a graph showing how
TBA varies across a grid of (\code{P_targeted}, \code{rb}) values.

The TBA is calculated as \eqn{1 + (P_{\mathrm{targeted}} \times rb)}.
}
\details{
The adjustment dampens large changes in biomass indices when the targeted
proportion is small by multiplying \code{rb} by \code{P_targeted}. The plot shades
the surface of \eqn{1 + P \times rb}. A dashed horizontal line marks \code{rb = 0}.
}
\examples{
TBA(P_targeted = 0.5, rb = -0.5)               # compute only
\donttest{
# compute + plot (requires ggplot2)
out <- TBA(P_targeted = 0.5, rb = -0.5, digits = 2, plot = TRUE)
out$plot
}

}
\seealso{
\code{\link{prop_target}} for targeted proportion; \code{\link{rb}} for proportional rate of change.
}
