% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{is.CI_within}
\alias{is.CI_within}
\title{Evaluate whether a confidence interval is within a tolerable interval}
\usage{
is.CI_within(CI, interval)
}
\arguments{
\item{CI}{estimated confidence interval (length 2)}

\item{interval}{tolerable interval range (length 2)}
}
\value{
logical
}
\description{
Return \code{TRUE} if an estimated confidence interval falls within
a tolerable \code{interval} range. Typically used for
equivalence, superiority, or non-inferiority testing.
}
\examples{

CI <- c(.2, .4)
LU <- c(.1, .3)
is.CI_within(CI, LU)        # not within tolerable interval
is.CI_within(CI, c(0, .5))  # is within wider interval

# complement indicates if CI is outside interval
!is.CI_within(CI, LU)

#####
# for superiority test
is.CI_within(CI, c(.1, Inf))  # CI is within tolerable interval

# for inferiority test
is.CI_within(CI, c(-Inf, .3))  # CI is not within tolerable interval

}
\seealso{
\code{\link{is.outside_CI}}, \code{\link{Spower}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
