% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rFromWilcoxAdjusted}
\alias{rFromWilcoxAdjusted}
\title{rFromWilcoxAdjusted}
\usage{
rFromWilcoxAdjusted(wilcoxModel, N, adjustFactor)
}
\arguments{
\item{wilcoxModel}{the Wilcox model}

\item{N}{number of measurements in the experiment}

\item{adjustFactor}{ad adjustment factor}
}
\value{
Invisibly returns a list with components:
\itemize{
\item \code{r}: adjusted effect size as a numeric scalar.
\item \code{z}: adjusted z-statistic.
\item \code{text}: character string that is also sent to the console.
}
}
\description{
rFromWilcoxAdjusted
}
\examples{
\donttest{
set.seed(1)
d <- data.frame(
  group = rep(c("A", "B"), each = 10),
  value = rnorm(20)
)
w <- stats::wilcox.test(value ~ group, data = d, exact = FALSE)
rFromWilcoxAdjusted(w, N = nrow(d), adjustFactor = 2)
}
}
