% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataviewer.R
\name{dataviewer}
\alias{dataviewer}
\title{Interactive Data Viewer with Filter and Code Generation}
\arguments{
\item{data}{A \code{data.frame} or \code{tibble}. If \code{NULL} or missing, an import UI is shown to load data interactively.}
}
\value{
Launches a Shiny application in the browser. Does not return a value.
}
\description{
Launches a Shiny application to explore and filter a 'data.frame' or 'tibble'.
If no data is provided, it opens an import panel to load a dataset from either the global environment or the packages.
}
\details{
This function provides:
\itemize{
\item A tab-based interface with data import and viewer options.
\item A checkbox panel to select/deselect columns.
\item An input for dplyr-compatible filter expressions.
\item A dynamically generated \code{dplyr} code preview.
\item Metadata display for the variables.
}

The filtering uses \code{dplyr::filter()} and generates user-friendly code to replicate the steps.
It also provides copyable R code that includes column selection and filtering logic.
}
\examples{
if (interactive()) {
  dataviewer(mtcars)
  dataviewer() # Opens the import panel
}

}
