% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{render_rtf}
\alias{render_rtf}
\title{Render to rtf}
\usage{
render_rtf(
  x,
  display_loc = NULL,
  remove_unicode_ws = TRUE,
  use_page_header = FALSE,
  version_check = TRUE
)
}
\arguments{
\item{x}{\code{docorator} object}

\item{display_loc}{path to save the output rtf to}

\item{remove_unicode_ws}{Option to remove unicode white space from text.}

\item{use_page_header}{If \code{TRUE} then all table headings will be migrated to the page header. See https://gt.rstudio.com/reference/tab_options.html#arg-page-header-use-tbl-headings}

\item{version_check}{Boolean indicating whether to print a note if gt or ggplot versions dont match between the original docorator object and the one being used for rendering}
}
\value{
This function saves an rtf to a specified location
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
Option \code{remove_unicode_ws} serves as a workaround for this
\href{https://github.com/rstudio/gt/issues/1437}{issue} in gt
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{gt::gtcars |>
  dplyr::slice_head(n = 10) |>
  dplyr::select(mfr, model, year, msrp) |>
  gt::gt(groupname_col = "mfr",
         row_group_as_column = TRUE) |>
  as_docorator(
   header = fancyhead(fancyrow("Header 1"), fancyrow("Header 2")),
   display_name = "mytbl") |>
 render_rtf()
}\if{html}{\out{</div>}}
}

