% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_cell_to_quad_xy}
\alias{hexify_cell_to_quad_xy}
\title{Convert Cell ID to Quad XY coordinates}
\usage{
hexify_cell_to_quad_xy(cell_id, resolution, aperture = 3L)
}
\arguments{
\item{cell_id}{Numeric vector of cell IDs (1-based)}

\item{resolution}{Grid resolution level (0-30)}

\item{aperture}{Grid aperture: 3, 4, or 7}
}
\value{
Data frame with columns:
\item{quad}{Quad number (0-11)}
\item{quad_x}{Continuous X coordinate in quad space}
\item{quad_y}{Continuous Y coordinate in quad space}
}
\description{
Converts DGGRID-compatible cell IDs to Quad XY coordinates
(continuous quad space). This is the cell center in quad coordinates.
}
\details{
Compatible with 'dggridR' dgSEQNUM_to_Q2DD().
}
\examples{
# Get Quad XY coordinates for a cell
result <- hexify_cell_to_quad_xy(cell_id = 1000, resolution = 10, aperture = 3)
print(result)

# Round-trip test
cell_id <- hexify_quad_xy_to_cell(result$quad, result$quad_x, result$quad_y,
                                   resolution = 10, aperture = 3)
# Should equal original cell_id
}
\seealso{
\code{\link{hexify_quad_xy_to_cell}} for the inverse operation,
\code{\link{hexify_cell_to_quad_ij}} for integer grid coordinates

Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
