% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_icosa_tri_to_quad_xy}
\alias{hexify_icosa_tri_to_quad_xy}
\title{Convert Icosa Triangle to Quad XY coordinates}
\usage{
hexify_icosa_tri_to_quad_xy(
  icosa_triangle_face,
  icosa_triangle_x,
  icosa_triangle_y
)
}
\arguments{
\item{icosa_triangle_face}{Triangle face number (0-19)}

\item{icosa_triangle_x}{X coordinate on triangle face}

\item{icosa_triangle_y}{Y coordinate on triangle face}
}
\value{
List with components:
\item{quad}{Quad number (0-11)}
\item{quad_x}{Continuous X coordinate in quad space}
\item{quad_y}{Continuous Y coordinate in quad space}
}
\description{
Converts icosahedral triangle coordinates (from Snyder projection)
to quad XY coordinates. This is an intermediate step in the pipeline.
}
\examples{
# First get triangle coordinates from lon/lat
fwd <- hexify_forward(lon = 2.35, lat = 48.86)

# Then convert to quad XY
quad_xy <- hexify_icosa_tri_to_quad_xy(
  icosa_triangle_face = fwd["face"],
  icosa_triangle_x = fwd["icosa_triangle_x"],
  icosa_triangle_y = fwd["icosa_triangle_y"]
)
print(quad_xy)
}
\seealso{
Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
