% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{plot_grid}
\alias{plot_grid}
\title{Plot hexagonal grid clipped to a polygon boundary}
\usage{
plot_grid(
  boundary,
  grid,
  crop = TRUE,
  boundary_fill = "gray95",
  boundary_border = "gray40",
  boundary_lwd = 0.5,
  grid_fill = "steelblue",
  grid_border = "steelblue",
  grid_lwd = 0.3,
  grid_alpha = 0.3,
  title = NULL,
  expand = 0.05
)
}
\arguments{
\item{boundary}{An sf/sfc polygon to clip to (e.g., country boundary)}

\item{grid}{A HexGridInfo object from \code{hex_grid()}}

\item{crop}{If TRUE (default), cells are cropped to boundary. If FALSE,
only complete hexagons within boundary are shown.}

\item{boundary_fill}{Fill color for the boundary polygon (default "gray95")}

\item{boundary_border}{Border color for boundary (default "gray40")}

\item{boundary_lwd}{Line width for boundary (default 0.5)}

\item{grid_fill}{Fill color for grid cells (default "steelblue")}

\item{grid_border}{Border color for grid cells (default "steelblue")}

\item{grid_lwd}{Line width for cell borders (default 0.3)}

\item{grid_alpha}{Transparency for cell fill (0-1, default 0.3)}

\item{title}{Plot title. If NULL (default), auto-generates title with cell area.}

\item{expand}{Expansion factor for plot limits (default 0.05)}
}
\value{
A ggplot object that can be further customized
}
\description{
A convenience function that creates a grid, clips it to a boundary polygon,
and plots the result in a single call.
}
\details{
This is a convenience wrapper around \code{grid_clip()} that handles the
common use case of visualizing a hexagonal grid over a geographic region.
}
\examples{
\donttest{
# Plot grid over France
france <- hexify_world[hexify_world$name == "France", ]
grid <- hex_grid(area_km2 = 2000)
plot_grid(france, grid)

# Customize colors
plot_grid(france, grid,
          grid_fill = "coral", grid_alpha = 0.5,
          boundary_fill = "lightyellow")

# Keep only complete hexagons
plot_grid(france, grid, crop = FALSE)

# Add ggplot2 customizations
library(ggplot2)
plot_grid(france, grid) +
  labs(subtitle = "ISEA3H Discrete Global Grid") +
  theme_void()
}
}
\seealso{
\code{\link{grid_clip}} for the underlying clipping function,
\code{\link{hex_grid}} for grid specification
}
