% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preproc-generics.R
\name{fit_transform}
\alias{fit_transform}
\title{Fit and transform data in one step}
\usage{
fit_transform(object, X, ...)
}
\arguments{
\item{object}{A preprocessing object (e.g., \code{prepper} or \code{pre_processor})}

\item{X}{A matrix or data frame to fit and transform}

\item{...}{Additional arguments passed to methods}
}
\value{
A list with two elements: \code{preproc} (the fitted preprocessor) and \code{transformed} (the transformed data)
}
\description{
Convenience function that fits a preprocessing pipeline to data and
immediately applies the transformation. This is equivalent to calling
\code{fit()} followed by \code{transform()} but is more efficient and convenient.
}
\examples{
# Fit and transform in one step
X <- matrix(rnorm(100), 10, 10)
preproc <- center()
result <- fit_transform(preproc, X)
fitted_preproc <- result$preproc
X_transformed <- result$transformed
}
\seealso{
\code{\link[=fit]{fit()}}, \code{\link[=transform]{transform()}}, \code{\link[=inverse_transform]{inverse_transform()}}
}
