% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoway_projector.R
\name{partial_inverse_projection.cross_projector}
\alias{partial_inverse_projection.cross_projector}
\title{Partial Inverse Projection of a Subset of the Loading Matrix in cross_projector}
\usage{
\method{partial_inverse_projection}{cross_projector}(x, colind, domain = c("X", "Y"), ...)
}
\arguments{
\item{x}{A \code{cross_projector} object.}

\item{colind}{A numeric vector specifying the columns (indices) of the \emph{latent factors}
or loadings to invert. Typically these correspond to a subset of canonical components
or principal components, etc.}

\item{domain}{Either \code{"X"} or \code{"Y"}, indicating which block's partial
loadings we want to invert.}

\item{...}{Additional arguments (unused by default, but may be used by subclasses).}
}
\value{
A matrix of shape \code{(length(colind) x p_block)} that, when multiplied
by factor scores restricted to \code{colind} columns, yields an
\code{(n x p_block)} reconstruction in the original domain block.
}
\description{
This function obtains the "inverse" mapping for a columnwise subset of the loading
matrix in the specified domain. In practice, if \code{v_mat} is not orthonormal
or not square, we use a pseudoinverse approach (via \code{MASS::ginv}).
}
\details{
By default, this is a minimal-norm solution for partial columns of \code{v_mat}.
If you need a different approach (e.g., ridge, direct solve, etc.), you can override
this method in your specific class or code.
}
\examples{
# Suppose 'cp' is a cross_projector, and we want only columns 1:3 of
# the Y block factors. Then:
#   inv_mat_sub <- partial_inverse_projection(cp, colind=1:3, domain="Y")
# The shape will be (3 x pY), so factor_scores_sub (n x 3) \%*\% inv_mat_sub => (n x pY).
}
