% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{reconstruct}
\alias{reconstruct}
\title{Reconstruct the data}
\usage{
reconstruct(x, ...)
}
\arguments{
\item{x}{The model fit, typically an object of a class that implements a \code{reconstruct} method}

\item{...}{Additional arguments passed to specific methods. Common parameters include:
\describe{
\item{\code{comp}}{A vector of component indices to use in the reconstruction}
\item{\code{rowind}}{The row indices to reconstruct (optional)}
\item{\code{colind}}{The column indices to reconstruct (optional)}
\item{\code{scores}}{(For \code{composed_projector} only) A numeric matrix of scores to reconstruct from}
}}
}
\value{
A reconstructed data set based on the selected components, rows, and columns
}
\description{
Reconstruct a data set from its (possibly) low-rank representation. This can be useful when analyzing
the impact of dimensionality reduction or when visualizing approximations of the original data.
}
\seealso{
\code{\link{bi_projector}} for an example of a two-way mapping model that can be reconstructed

Other reconstruct: 
\code{\link{reconstruct_new}()}
}
\concept{reconstruct}
