% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preproc-generics.R
\name{transform}
\alias{transform}
\title{Transform data using a fitted preprocessing pipeline}
\usage{
transform(object, X, ...)
}
\arguments{
\item{object}{A fitted preprocessing object}

\item{X}{A matrix or data frame to transform}

\item{...}{Additional arguments passed to methods}
}
\value{
The transformed data matrix
}
\description{
Apply a fitted preprocessing pipeline to new data. The preprocessing
object must have been fitted using \code{fit()} or \code{fit_transform()} before
calling this function.
}
\examples{
# Transform new data with fitted preprocessor
X_train <- matrix(rnorm(100), 10, 10)
X_test <- matrix(rnorm(50), 5, 10)

preproc <- center()
fitted_preproc <- fit(preproc, X_train)
X_test_transformed <- transform(fitted_preproc, X_test)
}
\seealso{
\code{\link[=fit]{fit()}}, \code{\link[=fit_transform]{fit_transform()}}, \code{\link[=inverse_transform]{inverse_transform()}}
}
