% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outpack_metadata.R
\name{orderly_metadata}
\alias{orderly_metadata}
\title{Read outpack metadata}
\usage{
orderly_metadata(id, root = NULL)
}
\arguments{
\item{id}{The id to fetch metadata for. An error will be thrown if
this id is not known}

\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function does not require that the directory is
configured for orderly, and can be any \code{outpack} root (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
A list of metadata. See the outpack schema for details
(\url{https://github.com/mrc-ide/outpack})
}
\description{
Read metadata for a particular id. You may want to use
\code{\link[=orderly_search]{orderly_search()}} to find an id corresponding to a
particular query.
}
\examples{
path <- orderly_example()
id <- orderly_run("data", root = path)

# Read metadata for this packet:
meta <- orderly_metadata(id, root = path)
names(meta)

# Information on files produced by this packet:
meta$files
}
