% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_search.R
\name{orderly_search}
\alias{orderly_search}
\title{Query orderly's database}
\usage{
orderly_search(
  expr,
  name = NULL,
  scope = NULL,
  subquery = NULL,
  parameters = NULL,
  envir = parent.frame(),
  location = NULL,
  allow_remote = NULL,
  fetch_metadata = FALSE,
  options = NULL,
  root = NULL
)
}
\arguments{
\item{expr}{The query expression. A \code{NULL} expression matches everything.}

\item{name}{Optionally, the name of the packet to scope the query on. This
will be intersected with \code{scope} arg and is a shorthand way of running
\code{scope = list(name = "name")}}

\item{scope}{Optionally, a scope query to limit the packets
searched by \code{pars}}

\item{subquery}{Optionally, named list of subqueries which can be
referenced by name from the \code{expr}.}

\item{parameters}{Optionally, a named list of parameters to substitute
into the query (using the \verb{this:} prefix)}

\item{envir}{Optionally, an environment to substitute into the
query (using the \verb{environment:} prefix). The default here is to
use the calling environment, but you can explicitly pass this in
if you want to control where this lookup happens.}

\item{location}{Optional vector of locations to pull from. We
might in future expand this to allow wildcards or exceptions.}

\item{allow_remote}{Logical, indicating if we should allow packets
to be found that are not currently unpacked (i.e., are known
only to a location that we have metadata from). If this is
\code{TRUE}, then in conjunction with \code{\link[=orderly_dependency]{orderly_dependency()}}
you might pull a large quantity of data.  The default is \code{NULL}. This is
\code{TRUE} if remote locations are listed explicitly as a character
vector in the \code{location} argument, or if you have specified
\code{fetch_metadata = TRUE}, otherwise \code{FALSE}.}

\item{fetch_metadata}{Logical, indicating if we should pull
metadata immediately before the search. If \code{location} is given,
then we will pass this through to
\code{\link[=orderly_location_fetch_metadata]{orderly_location_fetch_metadata()}} to filter locations
to update.  If pulling many packets in sequence, you \emph{will} want
to update this option to \code{FALSE} after the first pull, otherwise
it will update the metadata between every packet, which will be
needlessly slow.}

\item{options}{\strong{DEPRECATED}. Please don't use this any more, and
instead use the arguments \code{location}, \code{allow_remote} and
\code{fetch_metadata} directly.}

\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function does not require that the directory is
configured for orderly, and can be any \code{outpack} root (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
A character vector of matching ids. In the case of no
match from a query returning a single value (e.g., \code{latest(...)}
or \code{single(...)}) this will be a character missing value
(\code{NA_character_})
}
\description{
Evaluate a query against the orderly database (within
\verb{.outpack/}), returning a vector of matching packet ids.  Note
that by default this only searches through packets that are
unpacked and available for direct use on this computer; to search
within packets known to other locations (and that we might know
about via their metadata) you will need to use the \code{location},
\code{allow_remote} and \code{fetch_metadata} arguments.
}
\examples{
path <- orderly_example()

# Generate a bunch of packets:
suppressMessages({
  orderly_run("data", echo = FALSE, root = path)
  orderly_run("depends", echo = FALSE, root = path)
  for (n in c(2, 4, 6, 8)) {
    orderly_run("parameters", list(max_cyl = n), echo = FALSE, root = path)
  }
})

# By default, search returns everything, which is rarely what you want:
orderly_search(root = path)

# Restricting by name is common enough that there's a shortcut for
# it:
orderly_search(name = "data", root = path)
orderly_search(name = "parameters", root = path)

# Restrict to a parameter value:
orderly_search(quote(parameter:max_cyl > 4), name = "parameters",
               root = path)
}
