% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_fama_macbeth.R
\name{estimate_fama_macbeth}
\alias{estimate_fama_macbeth}
\title{Estimate Fama-MacBeth Regressions}
\usage{
estimate_fama_macbeth(
  data,
  model,
  vcov = "newey-west",
  vcov_options = NULL,
  data_options = NULL
)
}
\arguments{
\item{data}{A data frame containing the data for the regression. It must include a column
representing the time periods (defaults to \code{date}) and the variables specified in the \code{model}.}

\item{model}{A formula representing the regression model to be estimated in each cross-section.}

\item{vcov}{A character string indicating the type of standard errors to compute. Options are
\code{"iid"} for independent and identically distributed errors or \code{"newey-west"} for Newey-West
standard errors. Default is \code{"newey-west"}.}

\item{vcov_options}{A list of additional arguments to be passed to the
\code{NeweyWest()} function when \code{vcov = "newey-west"}. These can include options
such as \code{lag}, which specifies the number of lags to use in the Newey-West
covariance matrix estimation, and \code{prewhite}, which indicates whether to
apply a prewhitening transformation. Default is an empty list.}

\item{data_options}{A named list of \link{data_options} with characters, indicating the column
names required to run this function. The required column names identify dates. Defaults to
\code{date = date}.}
}
\value{
A data frame with the estimated risk premiums, the number of observations, standard
errors, and t-statistics for each factor in the model.
}
\description{
This function estimates Fama-MacBeth regressions by first running cross-sectional regressions
for each time period and then aggregating the results over time to obtain average risk premia
and corresponding t-statistics.
}
\examples{
set.seed(1234)

data <- tibble::tibble(
  date = rep(seq.Date(from = as.Date("2020-01-01"),
                      to = as.Date("2020-12-01"), by = "month"), each = 50),
  permno = rep(1:50, times = 12),
  ret_excess = rnorm(600, 0, 0.1),
  beta = rnorm(600, 1, 0.2),
  bm = rnorm(600, 0.5, 0.1),
  log_mktcap = rnorm(600, 10, 1)
)

estimate_fama_macbeth(data, "ret_excess ~ beta + bm + log_mktcap")
estimate_fama_macbeth(data, "ret_excess ~ beta + bm + log_mktcap", vcov = "iid")
estimate_fama_macbeth(data, "ret_excess ~ beta + bm + log_mktcap",
                      vcov = "newey-west", vcov_options = list(lag = 6, prewhite = FALSE))

# Use different column name for date
data |>
  dplyr::rename(month = date) |>
  estimate_fama_macbeth(
    "ret_excess ~ beta + bm + log_mktcap",
    data_options = data_options(date = "month")
 )

}
