% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Config.R
\name{Config}
\alias{Config}
\title{Config.R}
\description{
Config.R

Config.R
}
\details{
Class for manging the library configuration options. Creates the default
configuration without any source file, populates partial or missing config
elements, stores the config file to local machine, and provides easy access
methods for setting and getting config values.
}
\examples{

# Creates the configuration instance. Checks automatically if there is
# a previously stored configuration json file available for usage. Note
# that you don't need to explicitly define the config file path for the
# Config instance - by default the config file will be searched from and
# written in user-specific configuration directory for the package.

path   <- tempfile(fileext = ".json")
config <- Config$new(config_path = path)

# Getting and setting configuration values

value <- config$get("defailts.mode")
config$set("details.mode", "full")

# Saving the current configuration to local machine (to tmp folder with
# the given explicit file path in initialization).

config$save()

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{schema}}{configuration schema}

\item{\code{config}}{current configuration data}

\item{\code{path}}{configuration json file path}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Config-new}{\code{Config$new()}}
\item \href{#method-Config-get}{\code{Config$get()}}
\item \href{#method-Config-set}{\code{Config$set()}}
\item \href{#method-Config-save}{\code{Config$save()}}
\item \href{#method-Config-get_default_config}{\code{Config$get_default_config()}}
\item \href{#method-Config-get_default_schema}{\code{Config$get_default_schema()}}
\item \href{#method-Config-clone}{\code{Config$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Config-new"></a>}}
\if{latex}{\out{\hypertarget{method-Config-new}{}}}
\subsection{Method \code{new()}}{
Constructor for initializing the configuration. Checks the local machine
for existing configuration file is load_config = TRUE. Ensures that all
the project configuration values are included.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Config$new(load_config = TRUE, config_path = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{load_config}}{load configuration from local machine if available}

\item{\code{config_path}}{location of the used/stored configuration json file}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Config-get"></a>}}
\if{latex}{\out{\hypertarget{method-Config-get}{}}}
\subsection{Method \code{get()}}{
Mehod for getting configuration value based on configuration key.
Configuratio item children are separated with a dot in the key notation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Config$get(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{configuration property key for which to get the value}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Config-set"></a>}}
\if{latex}{\out{\hypertarget{method-Config-set}{}}}
\subsection{Method \code{set()}}{
Mehod for setting configuration value based on configuration key.
Configuration item children are separated with a dot in the key notation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Config$set(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{configuration property key for which to get the value}

\item{\code{value}}{value to set for the specified configuration key}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Config-save"></a>}}
\if{latex}{\out{\hypertarget{method-Config-save}{}}}
\subsection{Method \code{save()}}{
Method for saving the current configuration data into local machine.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Config$save()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Config-get_default_config"></a>}}
\if{latex}{\out{\hypertarget{method-Config-get_default_config}{}}}
\subsection{Method \code{get_default_config()}}{
Helper method for getting configuration default values. These default
values will be used in the configuration in case the configuration
properties are not present previously.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Config$get_default_config()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Config-get_default_schema"></a>}}
\if{latex}{\out{\hypertarget{method-Config-get_default_schema}{}}}
\subsection{Method \code{get_default_schema()}}{
Method for getting the full configuration schema. Apart from the
configuration data, the schema contains property descriptions as well as
all possible values for the configuration properties.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Config$get_default_schema()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Config-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Config-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Config$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
