% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindHazaRds.R
\name{vMax_modelsR}
\alias{vMax_modelsR}
\title{Compute the Tropical Cyclone Maximum Wind Speeds}
\usage{
vMax_modelsR(
  vMaxModel,
  cPs,
  eP,
  vFms = NULL,
  TClats = NULL,
  dPdt = NULL,
  beta = 1.3,
  rho = 1.15
)
}
\arguments{
\item{vMaxModel}{0=Arthur (1980),1=Holland (2008),2=Willoughby & Rahn (2004).3=Vickery & Wadhera (2008),4=Atkinson and Holliday (1977)}

\item{cPs}{Tropical cyclone central pressure (hPa)}

\item{eP}{Background environmental pressure (hPa)}

\item{vFms}{Forward speed of the storm m/s}

\item{TClats}{Tropical cyclone central latitude}

\item{dPdt}{rate of change in central pressure over time, hPa per hour from Holland 2008}

\item{beta}{exponential term for Holland vortex}

\item{rho}{density of air}
}
\value{
maximum wind speed m/s.
}
\description{
Compute the Tropical Cyclone Maximum Wind Speeds
}
\examples{
vMax_modelsR(vMaxModel=1,cPs=950,eP=1010,vFms = 1,TClats = -14,dPdt = .1)
}
