% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_cts.R
\name{ctSweepS}
\alias{ctSweepS}
\title{CTS–QCA: Single-condition threshold sweep}
\usage{
ctSweepS(
  dat,
  outcome = NULL,
  conditions = NULL,
  sweep_var,
  sweep_range,
  thrY,
  thrX_default = 7,
  dir.exp = NULL,
  include = "",
  incl.cut = 0.8,
  n.cut = 1,
  pri.cut = 0,
  extract_mode = c("first", "all", "essential"),
  return_details = TRUE,
  Yvar = NULL,
  Xvars = NULL
)
}
\arguments{
\item{dat}{Data frame containing the outcome and condition variables.}

\item{outcome}{Character. Outcome variable name. Supports negation with
tilde prefix (e.g., \code{"~Y"}) following QCA package conventions.}

\item{conditions}{Character vector. Names of condition variables.}

\item{sweep_var}{Character. Name of the condition to be swept.
Must be one of \code{conditions}.}

\item{sweep_range}{Numeric vector. Candidate thresholds for \code{sweep_var}.}

\item{thrY}{Numeric. Threshold for Y (fixed).}

\item{thrX_default}{Numeric. Default threshold for non-swept X variables.}

\item{dir.exp}{Directional expectations for \code{minimize}.
If \code{NULL} (default), no directional expectations are applied.
To compute the \strong{intermediate solution}, specify a numeric vector
(1, 0, or -1 for each condition). Example: \code{dir.exp = c(1, 1, 1)}
for three conditions all expected to contribute positively.}

\item{include}{Inclusion rule for \code{minimize}. 
\code{""} (default, QCA compatible) computes the \strong{complex solution}
without logical remainders.
Use \code{"?"} to include logical remainders for \strong{parsimonious}
(with \code{dir.exp = NULL}) or \strong{intermediate} solutions
(with \code{dir.exp} specified).}

\item{incl.cut}{Consistency cutoff for \code{\link[QCA]{truthTable}}.}

\item{n.cut}{Frequency cutoff for \code{truthTable}.}

\item{pri.cut}{PRI cutoff for \code{minimize}.}

\item{extract_mode}{Character. How to handle multiple solutions:
\code{"first"} (default), \code{"all"}, or \code{"essential"}.
See \code{\link{qca_extract}} for details.}

\item{return_details}{Logical. If \code{TRUE} (default), returns both
summary and detailed objects for use with \code{generate_report()}.}

\item{Yvar}{Deprecated. Use \code{outcome} instead.}

\item{Xvars}{Deprecated. Use \code{conditions} instead.}
}
\value{
If \code{return_details = FALSE}, a data frame with columns:
\itemize{
  \item \code{threshold} — swept threshold for \code{sweep_var}
  \item \code{expression} — minimized solution expression
  \item \code{inclS} — solution consistency
  \item \code{covS} — solution coverage
  \item (additional columns depending on \code{extract_mode})
}

If \code{return_details = TRUE}, a list with:
\itemize{
  \item \code{summary} — the data frame above
  \item \code{details} — per-threshold list of
    \code{threshold}, \code{thrX_vec}, \code{truth_table}, \code{solution}
}
}
\description{
Performs a threshold sweep for one focal condition X. For each threshold
in \code{sweep_range}, the outcome Y and all X variables are binarized
using user-specified thresholds, and a crisp-set QCA is executed.
}
\examples{
# Load sample data
data(sample_data)

# === Three Types of QCA Solutions ===

# 1. Complex Solution (default, QCA compatible)
result_comp <- ctSweepS(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2", "X3"),
  sweep_var = "X3",
  sweep_range = 7,
  thrY = 7,
  thrX_default = 7
  # include = "" (default), dir.exp = NULL (default)
)
head(result_comp$summary)

# 2. Parsimonious Solution (include = "?")
result_pars <- ctSweepS(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2", "X3"),
  sweep_var = "X3",
  sweep_range = 7,
  thrY = 7,
  thrX_default = 7,
  include = "?"  # Include logical remainders
)
head(result_pars$summary)

# 3. Intermediate Solution (include = "?" + dir.exp)
result_int <- ctSweepS(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2", "X3"),
  sweep_var = "X3",
  sweep_range = 7,
  thrY = 7,
  thrX_default = 7,
  include = "?",
  dir.exp = c(1, 1, 1)  # All conditions expected positive
)
head(result_int$summary)

# === Threshold Sweep Example ===

# Run single condition threshold sweep on X3 (complex solutions by default)
result <- ctSweepS(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2", "X3"),
  sweep_var = "X3",
  sweep_range = 6:8,
  thrY = 7,
  thrX_default = 7
)
head(result$summary)

# Run with negated outcome (~Y)
result_neg <- ctSweepS(
  dat = sample_data,
  outcome = "~Y",
  conditions = c("X1", "X2", "X3"),
  sweep_var = "X3",
  sweep_range = 6:8,
  thrY = 7,
  thrX_default = 7
)
head(result_neg$summary)
}
