% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_config_chart.R
\name{generate_config_chart}
\alias{generate_config_chart}
\title{Generate Configuration Chart from QCA Solution}
\usage{
generate_config_chart(
  sol,
  symbol_set = c("unicode", "ascii", "latex"),
  include_metrics = TRUE,
  language = c("en", "ja"),
  condition_order = NULL
)
}
\arguments{
\item{sol}{A solution object returned by \code{QCA::minimize()}, or
a list containing solution information.}

\item{symbol_set}{Character. One of \code{"unicode"}, \code{"ascii"}, 
or \code{"latex"}. Default is \code{"unicode"}.}

\item{include_metrics}{Logical. Whether to include consistency/coverage
metrics in the table. Default is TRUE.}

\item{language}{Character. \code{"en"} for English, \code{"ja"} for Japanese.
Default is \code{"en"}.}

\item{condition_order}{Character vector. Optional ordering of conditions
in the table rows. If NULL, conditions are ordered as they appear in paths.}
}
\value{
Character string containing Markdown-formatted table(s).
}
\description{
Creates a Markdown-formatted configuration chart (Fiss-style table)
from QCA minimization results. Supports single solution with multiple
paths, and multiple solutions (displayed as separate tables).
}
\examples{
\dontrun{
# After running QCA::minimize()
library(QCA)
tt <- truthTable(data, outcome = "Y", conditions = c("A", "B", "C"))
sol <- minimize(tt, include = "?", details = TRUE)

# Generate configuration chart
chart <- generate_config_chart(sol)
cat(chart)

# For LaTeX/PDF output (e.g., rticles)
chart <- generate_config_chart(sol, symbol_set = "latex")

# ASCII for maximum compatibility
chart <- generate_config_chart(sol, symbol_set = "ascii")

# Japanese labels
chart <- generate_config_chart(sol, language = "ja")
}
}
