#' Sales index for large retailers in Spain
#'
#' Sales index for food of large retailers in Spain
#'
#' @format Time series objects.
#' \describe{
#'   Monthly data from January 1995 to December 2019
#'   
#'   https://portal.mineco.gob.es/es-es/economiayempresa/EconomiaInformesMacro/Paginas/bdsice.aspx
#' }
#'         
#' @return No return value, called for side effects
#' 
#' @examples
#' \donttest{
#'  sales
#' }
"sales"

#' US GDP
#'
#' Seasonally adjusted quarterly US real gross domestic product (USgdp).
#'
#' @format Time series objects.
#' \describe{
#'   Quarterly data from 1962 to 2019
#' }
#'
#' @source \href{https://www.nber.org/}{USgdp}
#'         
#' @return No return value, called for side effects
#' 
#' @examples
#' \donttest{
#'  USgdp
#' }
"USgdp"

#' OECD GDP
#'
#' Seasonally adjusted quarterly OECD real gross domestic product (OECDgdp).
#'
#' @format Time series objects.
#' \describe{
#'   Quarterly data from 1962 to 2019
#'   
#'   https://portal.mineco.gob.es/es-es/economiayempresa/EconomiaInformesMacro/Paginas/bdsice.aspx
#' }
#'
#' @return No return value, called for side effects
#' 
#' @examples
#' \donttest{
#'  OECDgdp
#' }
"OECDgdp"

#' Methane concentration at Cape Grim in Australia
#'
#' Methane concentration at Cape Grim in Australia (ch4).
#'
#' @format Time series objects.
#' \describe{
#'   Monthly data from January 1992 to December 2019
#' }
#'
#' @source \href{https://www.csiro.au/en/research/natural-environment/atmosphere/Latest-greenhouse-gas-data}{CH4 data}
#'         
#' @return No return value, called for side effects
#' 
#' @examples
#' \donttest{
#'  ch4
#' }
"ch4"

#' Airpassengers in Spain
#' 
#' Foreign arrivals by air in Spain in thousands of passengers (airpas).
#'
#' @format Time series objects.
#' \describe{
#'   Monthly data from 1969
#'   
#'   https://portal.mineco.gob.es/es-es/economiayempresa/EconomiaInformesMacro/Paginas/bdsice.aspx
#' }
#' 
#' @return No return value, called for side effects
#' 
#' @examples
#' \donttest{
#'  airpas
#' }
"airpas"

#' Spanish GDP
#'
#' Quarterly real Spanish Gross Domestic Product (gdp)
#'
#' @format Time series objects.
#' \describe{
#'   Quarterly since 1995
#'   
#'   https://portal.mineco.gob.es/es-es/economiayempresa/EconomiaInformesMacro/Paginas/bdsice.aspx
#' }
#'
#' @return No return value, called for side effects
#' 
#' @examples
#' \donttest{
#'  gdp
#' }
"gdp"

#' Spanish Industrial Production Index
#' 
#' Spanish Industrial Production Index (ipi).
#'
#'
#' @format Objeto time series.
#' \describe{
#'   Monthly since 1975
#'   
#'   https://portal.mineco.gob.es/es-es/economiayempresa/EconomiaInformesMacro/Paginas/bdsice.aspx
#' }
#'
#' @return No return value, called for side effects
#' 
#' @examples
#' \donttest{
#'  ipi
#' }
"ipi"
