#' Plot the pdf and cdf of Unit-Garima distribution (UGa)
#'
#' @description
#' To show the pdf (or the cdf) of UGa distribution by specified parameter \code{theta}.
#'
#' @param x       vector of quantile.
#' @param theta   shape parameter, where \eqn{\theta > 0}.
#'
#' @import graphics
#' @import lamW
#' @import stats
#'
#' @return No return value, called for side effects
#'
#' @export
#' @name plotUGa
#' @examples
#' # library(lamW) is required for rUGa() function
#  require(lamW)
#' x <- rUGa(101,theta=1.5)
#' x

#' @export
#' @rdname plotUGa
#' @examples
#' plotpdfUGa(x,theta = 1.5)
#'
plotpdfUGa <- function(x,theta){
  xs <- sort(x)
  tta <- theta
  fxs<- dUGa(xs,theta=tta)
  plot(xs,fxs,type = "l",ylab="f(x)",xlab="x",lwd=2,col=1,lty=1)
  title(main = "The pdf of unit-Garima distribution with parameter theta")
}

#' @export
#' @rdname plotUGa
#' @examples
#' plotcdfUGa(x,theta = 1.5)
#'
plotcdfUGa <- function(x,theta){
  xs <- sort(x)
  tta <- theta
  p <- pUGa(xs,theta = tta)
  plot(xs,p,type = "l",ylab="F(x)",xlab="x",ylim = c(0,1),lwd=2,col=1,lty=1)
  title(main = "The cdf of unit-Garima distribution with parameter theta")
}


