% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{QMEDDonEq}
\alias{QMEDDonEq}
\title{QMED donor adjustment}
\usage{
QMEDDonEq(
  QMED.scd,
  QMEDgObs,
  QMEDgCds,
  Distance = NULL,
  xSI,
  ySI,
  xDon,
  yDon,
  alpha = TRUE
)
}
\arguments{
\item{QMED.scd}{Ungauged QMED estimate for the site of interest}

\item{QMEDgObs}{the observed QMED at the donor site}

\item{QMEDgCds}{the QMED equation derived QMED at the donor site}

\item{Distance}{The distance in km between the catchment centroids of the site of interest and donor site.}

\item{xSI}{For when distance is not known - the catchment centroid easting for the site of interest.}

\item{ySI}{For when distance is not known - the catchment centroid northing for the site of interest}

\item{xDon}{For when distance is not known - the catchment centroid easting for the donor site}

\item{yDon}{For when distance is not known - the catchment centroid northing for the donor site}

\item{alpha}{a logical argument with a default of TRUE. When FALSE the exponent in the donor equation is set to one. Otherwise it is determined by the distance between the donor and the subject site}
}
\description{
Applies a donor adjustment to the median annual maximum flow (QMED) estimate
}
\details{
Although a single donor adjustment can be applied with the QMED function, this additional function is provided for flexibility. The method is that of FEH2025.
}
\examples{
# Get observed QMED for site 15006
q_ob <- GetQMED(15006)

# Get QMED equation estimated QMED for the donor site
q_cd <- QMED(CDs = GetCDs(15006))



# Apply the QMEDDonEq function with the information gained, assuming
# a distance of 30km and subject site QMED estimate of 3.9
QMEDDonEq(
  QMED.scd = 3.9, QMEDgObs = q_ob, QMEDgCds = q_cd,
  Distance = 30
)

}
\author{
Anthony Hammond
}
