% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{UEF}
\alias{UEF}
\title{Urban expansion factor}
\usage{
UEF(Year)
}
\arguments{
\item{Year}{The year for consideration. Numeric}
}
\value{
A numeric urban expansion factor.
}
\description{
This function provides a coefficient to multiply by URBEXT2015 to adjust it to a given year
}
\details{
The urban expansion factor is that of the FEH2025 method. The urban expansion model assumes a national average expansion as a function of year. This means that on some catchments the value will be overestimated (primarily on rural ones) and on others the value will be underestimated (primarily on urban ones).
}
\examples{
# Get an expansion factor for the year 2025
UEF(2025)

}
\author{
Anthony Hammond
}
