% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Perrin.R
\name{Perrin}
\alias{Perrin}
\alias{A001608}
\title{Perrin numbers}
\usage{
Perrin(n, gmp = TRUE)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{gmp}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A001608}{A001608}, the \emph{n}th \emph{Perrin} number is given as
\deqn{F_n = F_{n-2} + F_{n-3}}
where the first 6 entries are	3, 0, 2, 3, 2, 5.
}
\examples{
## generate first 30 Perrin numbers
print(Perrin(30))

}
