% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.tsd_onset}
\alias{summary.tsd_onset}
\title{Summary method for \code{tsd_onset} objects}
\usage{
\method{summary}{tsd_onset}(object, ...)
}
\arguments{
\item{object}{An object of class 'tsd_onset'
containing the results of a \code{seasonal_onset} analysis.}

\item{...}{Additional arguments (not used).}
}
\value{
This function is used for its side effect, which is printing a summary message to the console.
}
\description{
Summarize key results from a seasonal onset analysis.
}
\examples{
# Create a `tsd` object
tsd_data <- generate_seasonal_data()

# Create a `tsd_onset` object
tsd_onset <- seasonal_onset(
  tsd = tsd_data,
  k = 3,
  disease_threshold = 100,
  season_start = 21,
  season_end = 20,
  level = 0.95,
  only_current_season = TRUE
)
# Print the summary
summary(tsd_onset)
}
